#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/app_options_menu'
require_relative '../../pages/landing_appointments'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../pages/landing_notifications'
require_relative '../../pages/notifications'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/appointments/new_appointment_request'

describe '[Story# VAR-5705: Landing Page- Notifications button]
          [Story# VAR-5706: Notifications- In App: List ]
          [Story# VAR-5708: Notification List- Link to detail view]
          [Story# VAR-5709: Notification Details – Follow Up Appointment Reminder]
          [Story# VAR-6428: Notifications - In App List (update columns)]
          [Story# VAR-5710: Delete Notification]
          [Story# VAR-5707: Notifications – Icon with unread notification count] do
          [Story# VAR-5711: Read/Unread Status Indicator]
          [Story# VAR-7010: Notification Details: Date Sent field - formatting]' do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @eula = Eula.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)

    @db = connectToMongoDBVMM("vmm")
    restoreCollection("inAppMessages","vmm","inAppMessages-vmm.json",@db)
    @common.loginEndsOnHome(pw_redacted)
    @common.waitWhileSpinnerPresent
  end

  after(:all) do
    @driver.close
  end

  context '[Story# VAR-5705 AC#6142 TC#6143: Landing Page- Button labeled "Notifcations"/ Back button "Appointments/Requests"]'do
    it "should see and be able to click the Notifications button on the landing page" do

      expect(@landing_notifications.notifications_btn_element.when_present(TIME_OUT_LIMIT).text).to include("Notifications")
    end

    it "should verify a Notifications page with header title Notifications" do
      @common.waitWhileSpinnerPresent
      @landing_notifications.appointments_heading_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickNotificationsButton
      @common.waitWhileSpinnerPresent
      @common.wait_until_elements_size_steadied(TIME_OUT_LIMIT)
      @landing_notifications.header_title_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.header_title_element.when_present(TIME_OUT_LIMIT).text).to eq("Notifications")


    end

    it "it sholuld verify a back button with title Appointments/Requests to navigate back to the landing page" do
      expect(@landing_notifications.appointment_btn_element.text).to eq("Appointments/Requests")
    end

  end

  context '[Story# VAR-5706 AC#5614  TC#5615: Notifications list]' do
    it "should show all notifications in list- Label: Notifications/ Subject: VA Appointments - Follow-up Appointment Reminder " do
      expect(@landing_notifications.notifications_header_element.text).to eq("Notification")
      expect(@landing_notifications.notifications_subject_element.text).to eq("VA Appointments - Follow-up Appointment Reminder")
    end

    it "should show message You do not have any notifications at this time. when no notifications are present" do
      restoreCollection("inAppMessages","vmm","noInAppMessages-vmm.json",@db)
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @landing_notifications.notifications_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.appointments_heading_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickNotificationsButton
      @landing_notifications.no_notifications_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.no_notifications_element.text).to eq("You do not have any notifications at this time.")
    end

  end

  context '[Story# VAR-5708 AC#6852  TC#6853: Notification list: Link to detail view]' do
    it "should show notification page with panel header View Notification" do
      restoreCollection("inAppMessages","vmm","inAppMessages-vmm.json",@db)
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @landing_notifications.notifications_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.appointments_heading_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickNotificationsButton
      @landing_notifications.notification_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notifications_list_elements[0].click
      @common.waitWhileSpinnerPresent
      @landing_notifications.panel_header_noti_page_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.panel_header_noti_page_element.text).to eq("View Notification")
    end

    it "shoud return to notifiations list when Return to Notifications List button is clicked" do
      @common.waitWhileSpinnerPresent
      @landing_notifications.clickReturnToNotificationList
      @common.waitWhileSpinnerPresent
      @landing_notifications.header_title_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.header_title_element.when_present(TIME_OUT_LIMIT).text).to eq("Notifications")
    end

    it "should return to Appointment/Requests page when Appointment/Request navigation is selected on the notifications detail page" do
      @landing_notifications.notification_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notifications_list_elements[0].click
      @common.waitWhileSpinnerPresent
      @landing_notifications.appointment_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickBackButton
      @common.waitWhileSpinnerPresent
      @landing_notifications.appt_page_title_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.notifications_btn_element.when_present(TIME_OUT_LIMIT).text).to include("Notifications")
    end

  end


  context '[Story# VAR-5709 AC#VAR-6821 TC#VAR-6822: Notificationa details]' do
    it 'should show notifications detail content for a follow up appointment reminder as follows
    VA Appointments (source of the notifications)
    Date/time the notification was sent (format: MM/DD/YYYY HHMM 24 hour clock)
    Time zone (e.g. America/New York format)
    Horizontal Rule
    Content:
    It is time to schedule a Follow-Up Appointment at <Clinic name>
    Your provider has requested that you schedule a follow up appointment around 04/14/2017. Please contact the facility below to make an appointment:
    <Facility Name>
    <Clinic Name>
    <Clinic friendly location name> (display if valued)
    <Provider First Name> <Provider Last Name> (display if valued)
    View VA Facilities (hyperlink label to facility locator page:<To be determined - if not available, remove link>
    Your VA Healthcare Team
    A button labeled "<add icon> New Appointment/Request" is shown in the upper right corner of the notification box.' do
      restoreCollection("inAppMessages","vmm","inAppMessages-vmm.json",@db)
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @landing_notifications.notifications_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.appointments_heading_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickNotificationsButton
      @common.waitWhileSpinnerPresent
      @landing_notifications.notification_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notifications_list_elements[0].click
      @common.waitWhileSpinnerPresent
      expect(@landing_notifications.notification_detail_follow_up_appt_element.text).to eq("VA Appointments - Follow-up Appointment Reminder\nDate Sent:\n06/15/2017 @ 1500\nTimezone Unavailable\na full end-to-end-test View Facilities")
    end

    it 'show the following below the notifications details content
    The Return to Notification list button is displayed below the notification information' do
      expect(@landing_notifications.notification_details_action_element.text).to eq("Return to Notification List Delete")
    end

    it "Selecting the button opens the New Appointment/Request form" do
      @landing_notifications.notification_detail_new_appt_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notification_detail_new_appt
      @common.waitWhileSpinnerPresent
      @landing_notifications.appt_page_title_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.appt_page_title_element.text).to eq("New Appointment/Request")
    end

  end

  context '[Story# VAR-6428 AC#6854 TC#6855: Notifications- In App List (Update Columns)]' do
    it 'should show Notification and Source columns: status' do
      restoreCollection("inAppMessages","vmm","inAppMessages-vmm.json",@db)
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @landing_notifications.notifications_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.appointments_heading_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickNotificationsButton
      @common.waitWhileSpinnerPresent
      @landing_notifications.status_col_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.status_col_element.text).to eq("Status")
    end

    it 'should show Notification and Source columns: Notification' do
      @landing_notifications.notification_col_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.notification_col_element.text).to eq("Notification")
    end

    it 'should show Notification and Source columns: source' do
      @landing_notifications.source_col_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.source_col_element.text).to eq("Source")
    end

    it 'should show Notification column with the title' do
      @landing_notifications.notification_col_title_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.notification_col_title_element.text).to eq("This is a title")
    end

    it 'should show Source column with the source field' do
      @landing_notifications.source_col_title_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.source_col_title_element.text).to eq("VA Appointments - Follow-up Appointment Reminder")
    end
  end

  context '[Story# VAR-5710 AC# TC#: Delete Notification]' do
    it 'should show a confirmation modal when the delete button is selected' do
      @landing_notifications.notification_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notifications_list_elements[0].click
      @common.waitWhileSpinnerPresent
      @landing_notifications.return_to_note_list_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.delete_btn_element.wait_until_present(TIME_OUT_LIMIT)
      #@landing_notifications.delete_btn

      # @detail.back_btn
      button_element = @driver.button(:id => 'delete-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @landing_notifications.delete_modal_body_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.delete_modal_body_element.text).to eq("You are deleting this notification from your list. Do you want to continue?")

    end

    it 'should show Yes and No buttons for the confirmation modal. No takes back to notification details' do

      @landing_notifications.delete_modal_no_btn
      expect(@landing_notifications.header_title_element.text).to eq("View Notification")
    end

    it 'should show Yes and No buttons for the confirmation modal. Yes returns the user back to notifications page' do
      @landing_notifications.delete_btn
      @landing_notifications.delete_modal_body_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.delete_modal_yes_btn
      @landing_notifications.panel_header_noti_page_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.panel_header_noti_page_element.text).to include("Notification")
    end

  end

  context 'Story# VAR-5711 AC#7016 TC#7017: Read/Unread Status Indicator' do
    it 'should show a closed envelope to indicate unread status for the notification' do
      restoreCollection("inAppMessages","vmm","inAppMessages-vmm.json",@db)
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @landing_notifications.notifications_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.appointments_heading_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickNotificationsButton
      @landing_notifications.read_unread_indicator_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.read_unread_indicator_element.visible?).to eq(true)
    end

    it 'should show no envelope to indicate read status for the notification' do
      @landing_notifications.notifications_list_elements[0].click
      @common.waitWhileSpinnerPresent
      @landing_notifications.return_to_note_list_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickReturnToNotificationList
      expect(@landing_notifications.read_unread_indicator_element.visible?).to eq(false)
    end

  end

  context 'Story# VAR-5707 AC#7196 TC#7197' do
    it 'should show 6 notifications on the notifications buttons' do
      restoreCollection("inAppMessages","vmm","inAppMessages-vmm.json",@db)
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @landing_notifications.notifications_counter_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.notifications_counter_element.text).to eq("6")
    end

    it 'should show 5 notifications after one of the notifications is read' do
      @landing_notifications.notifications_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickNotificationsButton
      @landing_notifications.notification_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notifications_list_elements[0].click
      @common.waitWhileSpinnerPresent
      @landing_notifications.return_to_note_list_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickReturnToNotificationList
      @landing_notifications.clickBackButton
      @common.waitWhileSpinnerPresent
      @landing_notifications.notifications_counter_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_notifications.notifications_counter_element.text).to eq("5")
    end

  end

  context 'Story# VAR-7010 AC#7260 TC#7261: Notification Details: Date Sent field - formatting' do
    it 'should show a Date Sent field and have @ before the time' do
      restoreCollection("inAppMessages","vmm","inAppMessages-vmm.json",@db)
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @landing_notifications.notifications_btn_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.appointments_heading_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.clickNotificationsButton
      @landing_notifications.notification_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notifications_list_elements[0].click
      @common.waitWhileSpinnerPresent
      expect(@landing_notifications.notification_detail_follow_up_appt_element.text).to eq("VA Appointments - Follow-up Appointment Reminder\nDate Sent:\n06/15/2017 @ 1500\nTimezone Unavailable\na full end-to-end-test View Facilities")
    end

    it 'should show Step 1 Type of Care Selection Page when NEw Appointment is clicked' do
      @landing_notifications.notification_detail_new_appt_element.wait_until_present(TIME_OUT_LIMIT)
      @common.selectAddAppointmentButton("VA")
      @landing_notifications.appt_page_title_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@new_appointment.step_1_type_of_care_element.text).to eq "Step 1: Type of Care"
    end

  end
end
